<?php
namespace PSF;

if (!defined('ABSPATH')) {
    exit;
}

class Helpers
{
    public static function sanitize_url(string $url)
    {
        $url = trim($url);
        if ($url === '') {
            return '';
        }
        $sanitized = \esc_url_raw($url, ['http', 'https']);
        return $sanitized ?: '';
    }

    public static function validate_url(string $url): bool
    {
        if ($url === '') {
            return true; // empty allowed; handled as not set
        }
        return (bool) filter_var($url, FILTER_VALIDATE_URL) && preg_match('/^https?:\/\//i', $url);
    }

    public static function esc_attr($value)
    {
        return \esc_attr($value);
    }
}