<?php
namespace PSF;

if (!defined('ABSPATH')) {
    exit;
}

class Frontend
{
    public static function init(): void
    {
        add_action('wp_enqueue_scripts', [self::class, 'enqueue_assets']);
        add_action('woocommerce_single_product_summary', [self::class, 'render_shortfacts_block'], 35);
    }

    public static function enqueue_assets(): void
    {
        wp_enqueue_style('psf-frontend', PSF_PLUGIN_URL . 'assets/frontend.css', [], PSF_PLUGIN_VERSION);
        wp_enqueue_script('psf-frontend', PSF_PLUGIN_URL . 'assets/frontend.js', ['jquery'], PSF_PLUGIN_VERSION, true);
    }

    public static function render_shortfacts_block(): void
    {
        // Allow display during trial; block only if expired and unlicensed
        $reg = (int) \get_option('psf_registration_date');
        $now = \current_time('timestamp');
        $days_used = $reg ? floor(($now - $reg) / DAY_IN_SECONDS) : 9999;
        $expired = ($days_used >= 30);
        if (\function_exists('psf_is_licensed') && !\psf_is_licensed() && $expired) {
            return;
        }
        global $product;
        if (!$product) {
            return;
        }
        $facts = get_post_meta($product->get_id(), '_psf_shortfacts', true);
        if (empty($facts)) {
            // fallback to legacy meta key
            $facts = get_post_meta($product->get_id(), '_eml_shortfacts', true);
        }
        if (empty($facts) || !is_array($facts)) {
            return;
        }
        // Normalize: remove empties
        $facts = array_values(array_filter(array_map('trim', $facts), function($v){ return $v !== ''; }));
        if (count($facts) === 0) {
            return;
        }

        $text_size = get_option('psf_text_size', 'medium');
        $style = get_option('psf_bullet_style', 'bullet');
        $heading_text = get_option('psf_heading_text', 'Key Features');
        $show_heading = get_option('psf_show_heading', 'yes') === 'yes';
        $class_map = [ 'bullet' => 'bullet', 'check' => 'check', 'number' => 'number' ];
        $style_class = isset($class_map[$style]) ? $class_map[$style] : 'bullet';
        echo '<div class="eml-wrapper shortfacts text-' . \esc_attr($text_size) . '">';
        if ($show_heading && $heading_text !== '') {
            echo '<h3 class="eml-heading">' . \esc_html($heading_text) . '</h3>';
        }
        echo '<ul class="eml-shortfacts-list style-' . \esc_attr($style_class) . '">';
        foreach ($facts as $fact) {
            echo '<li class="eml-shortfact-item">' . \esc_html($fact) . '</li>';
        }
        echo '</ul>';
        echo '</div>';
    }
}