/* Admin JS for Product Shortfacts */
if (typeof jQuery !== 'undefined') {
  (function($){
      $(function(){
          // Auto-open license modal if unlicensed and modal exists
          try {
              var licensed = (typeof PSFAdmin !== 'undefined') ? !!PSFAdmin.licensed : false;
              var expired = (typeof PSFAdmin !== 'undefined') ? !!PSFAdmin.expired : false;
              var $overlay = $('#eml-modal-overlay');
              var status = (typeof PSFAdmin !== 'undefined' && PSFAdmin.status) ? PSFAdmin.status : '';
              if ((!licensed) && expired && $overlay.length && !status) {
                  $overlay.attr('aria-hidden', 'false').addClass('open');
              }
              $('#eml-modal-close').on('click', function(){
                  $overlay.attr('aria-hidden', 'true').removeClass('open');
              });
              // Close on overlay click
              $overlay.on('click', function(e){
                  if (e.target === this) {
                      $overlay.attr('aria-hidden', 'true').removeClass('open');
                  }
              });
          } catch(e) {
              // noop
          }
      });
  })(jQuery);
} else {
  // Vanilla JS fallback for environments without jQuery (e.g., static previews)
  (function(){
    document.addEventListener('DOMContentLoaded', function(){
      try {
        var licensed = (typeof window.PSFAdmin !== 'undefined') ? !!window.PSFAdmin.licensed : false;
        var expired = (typeof window.PSFAdmin !== 'undefined') ? !!window.PSFAdmin.expired : false;
        var overlay = document.getElementById('eml-modal-overlay');
        var status = (typeof window.PSFAdmin !== 'undefined' && window.PSFAdmin.status) ? window.PSFAdmin.status : '';
        if ((!licensed) && expired && overlay && !status) {
          overlay.setAttribute('aria-hidden', 'false');
          overlay.classList.add('open');
        }
        var closeBtn = document.getElementById('eml-modal-close');
        if (closeBtn && overlay) {
          closeBtn.addEventListener('click', function(){
            overlay.setAttribute('aria-hidden', 'true');
            overlay.classList.remove('open');
          });
        }
        if (overlay) {
          overlay.addEventListener('click', function(e){
            if (e.target === overlay) {
              overlay.setAttribute('aria-hidden', 'true');
              overlay.classList.remove('open');
            }
          });
        }
      } catch(e) {
        // noop
      }
    });
  })();
}