<?php
namespace wefathemes\externalmarketplaceslinksforwoocommerce;

if (!defined('ABSPATH')) {
    exit;
}

class Frontend
{
    public static function init(): void
    {
        add_action('wp_enqueue_scripts', [self::class, 'enqueue_assets']);
        add_action('woocommerce_single_product_summary', [self::class, 'render_links_block'], 35);
    }

    public static function enqueue_assets(): void
    {
        wp_enqueue_style('extemali-frontend', EXTEMALI_PLUGIN_URL . 'assets/frontend.css', [], EXTEMALI_PLUGIN_VERSION);
        wp_enqueue_script('extemali-frontend', EXTEMALI_PLUGIN_URL . 'assets/frontend.js', ['jquery'], EXTEMALI_PLUGIN_VERSION, true);
    }

    public static function render_links_block(): void
    {
        if (\function_exists('extemali_is_licensed') && !\extemali_is_licensed()) {
            return;
        }
        global $product;
        if (!$product) {
            return;
        }

        $links = get_post_meta($product->get_id(), '_extemali_marketplace_links', true);
        if (empty($links) || !is_array($links)) {
            $links = get_post_meta($product->get_id(), '_eml_marketplace_links', true);
        }
        if (empty($links) || !is_array($links)) {
            return;
        }

        $display_type = get_option('extemali_display_type', 'text');
        $image_size = get_option('extemali_image_size', 'medium');
        $text_size = get_option('extemali_text_size', 'medium');
        $show_text = get_option('extemali_show_text_with_images', 'yes') === 'yes';

        $count = 0;
        foreach (Helpers::MARKETPLACES as $m) {
            if (!empty($links[$m])) {
                $count++;
            }
        }
        if ($count === 0) {
            return;
        }

        $heading_text = get_option('extemali_heading_text', 'Buy on Marketplaces');
        $show_heading = get_option('extemali_show_heading', 'yes') === 'yes';
        echo '<div class="eml-wrapper display-' . \esc_attr($display_type) . ' text-' . \esc_attr($text_size) . '">';
        if ($show_heading && $heading_text !== '') {
            echo '<h3 class="eml-heading">' . \esc_html($heading_text) . '</h3>';
        }
        echo '<div class="eml-grid size-' . \esc_attr($image_size) . ' link-count-' . \esc_attr($count) . '">';
        foreach (Helpers::MARKETPLACES as $marketplace) {
            $url = isset($links[$marketplace]) ? Helpers::sanitize_url($links[$marketplace]) : '';
            if ($url === '' || !Helpers::validate_url($url)) {
                continue;
            }
            $name = ucfirst($marketplace);
            $label = $show_text ? ' ' . \esc_html($name) : '';
            $icon_url = Helpers::get_marketplace_icon_url($marketplace);
            if ($display_type === 'image' && $icon_url) {
                $fallback = EXTEMALI_PLUGIN_URL . 'assets/img/marketplaces/default.svg';
                echo '<a class="eml-btn image" href="' . \esc_url($url) . '" target="_blank" rel="noopener nofollow sponsored">';
                $icon_src = (strpos($icon_url, 'data:') === 0) ? \esc_attr($icon_url) : \esc_url($icon_url);
                echo '<img class="eml-logo" src="' . \esc_attr($icon_src) . '" alt="' . \esc_attr($name) . '" loading="lazy" decoding="async" onerror="this.onerror=null;this.src=\'' . \esc_url($fallback) . '\';" />';
                if ($show_text) {
                    echo '<span class="eml-text">' . \esc_html($name) . '</span>';
                }
                echo '</a>';
            } else {
                echo '<a class="eml-btn text" href="' . \esc_url($url) . '" target="_blank" rel="noopener nofollow sponsored">' . \esc_html($name) . '</a>';
            }
        }
        echo '</div>';
        echo '</div>';
    }
}