/* Admin JS for External Marketplaces Links */
if (typeof jQuery !== 'undefined') {
  (function($){
      $(function(){
          // Auto-open license modal if unlicensed and modal exists
          try {
              var licensed = (typeof EXTEMALIAdmin !== 'undefined') ? !!EXTEMALIAdmin.licensed : ((typeof EMLAdmin !== 'undefined') ? !!EMLAdmin.licensed : false);
              var expired = (typeof EXTEMALIAdmin !== 'undefined') ? !!EXTEMALIAdmin.expired : ((typeof EMLAdmin !== 'undefined') ? !!EMLAdmin.expired : false);
              var $overlay = $('#eml-modal-overlay');
              var status = (typeof EXTEMALIAdmin !== 'undefined' && EXTEMALIAdmin.status) ? EXTEMALIAdmin.status : ((typeof EMLAdmin !== 'undefined' && EMLAdmin.status) ? EMLAdmin.status : '');
              if ((!licensed) && $overlay.length && !status) {
                  $overlay.attr('aria-hidden', 'false').addClass('open');
              }
              $('#eml-modal-close').on('click', function(){
                  $overlay.attr('aria-hidden', 'true').removeClass('open');
              });
              // Close on overlay click
              $overlay.on('click', function(e){
                  if (e.target === this) {
                      $overlay.attr('aria-hidden', 'true').removeClass('open');
                  }
              });
          } catch(e) {
              // noop
          }
      });
  })(jQuery);
} else {
  // Vanilla JS fallback for environments without jQuery (e.g., static previews)
  (function(){
    document.addEventListener('DOMContentLoaded', function(){
      try {
        var licensed = (typeof window.EXTEMALIAdmin !== 'undefined') ? !!window.EXTEMALIAdmin.licensed : ((typeof window.EMLAdmin !== 'undefined') ? !!window.EMLAdmin.licensed : false);
        var expired = (typeof window.EXTEMALIAdmin !== 'undefined') ? !!window.EXTEMALIAdmin.expired : ((typeof window.EMLAdmin !== 'undefined') ? !!window.EMLAdmin.expired : false);
        var overlay = document.getElementById('eml-modal-overlay');
        var status = (typeof window.EXTEMALIAdmin !== 'undefined' && window.EXTEMALIAdmin.status) ? window.EXTEMALIAdmin.status : ((typeof window.EMLAdmin !== 'undefined' && window.EMLAdmin.status) ? window.EMLAdmin.status : '');
        if ((!licensed) && overlay && !status) {
          overlay.setAttribute('aria-hidden', 'false');
          overlay.classList.add('open');
        }
        var closeBtn = document.getElementById('eml-modal-close');
        if (closeBtn && overlay) {
          closeBtn.addEventListener('click', function(){
            overlay.setAttribute('aria-hidden', 'true');
            overlay.classList.remove('open');
          });
        }
        if (overlay) {
          overlay.addEventListener('click', function(e){
            if (e.target === overlay) {
              overlay.setAttribute('aria-hidden', 'true');
              overlay.classList.remove('open');
            }
          });
        }
      } catch(e) {
        // noop
      }
    });
  })();
}